import pandas as pd  
from sklearn.preprocessing import LabelEncoder   
import pickle 
from decision_company import read_csv_file, encoder_instance, encode_column, choose_data_types, get_columns

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Encode categorical variables  
le = encoder_instance()  
categorical_columns = get_columns(choose_data_types(credit_customers, ['object']))  
for column in categorical_columns:  
    credit_customers[column] = encode_column(le, credit_customers[column])  

print("credit_customers")
print(credit_customers)  
pickle.dump(credit_customers,open("./ref_result/credit_customers.pkl","wb"))